/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Queue<T>
implements Iterable<T> {
    protected T[] values;
    protected int head = 0;
    protected int tail = 0;
    public int size = 0;
    private QueueIterable iterable;

    public Queue() {
        this(16);
    }

    public Queue(int initialSize) {
        this.values = new Object[initialSize];
    }

    public Queue(int initialSize, Class<T> type) {
        this.values = (Object[])ArrayReflection.newInstance(type, initialSize);
    }

    public void addLast(T object) {
        T[] values2 = this.values;
        if (this.size == values2.length) {
            this.resize(values2.length << 1);
            values2 = this.values;
        }
        values2[this.tail++] = object;
        if (this.tail == values2.length) {
            this.tail = 0;
        }
        ++this.size;
    }

    public void addFirst(T object) {
        T[] values2 = this.values;
        if (this.size == values2.length) {
            this.resize(values2.length << 1);
            values2 = this.values;
        }
        int head2 = this.head;
        if (--head2 == -1) {
            head2 = values2.length - 1;
        }
        values2[head2] = object;
        this.head = head2;
        ++this.size;
    }

    public void ensureCapacity(int additional) {
        int needed = this.size + additional;
        if (this.values.length < needed) {
            this.resize(needed);
        }
    }

    protected void resize(int newSize) {
        T[] values2 = this.values;
        int head2 = this.head;
        int tail = this.tail;
        Object[] newArray = (Object[])ArrayReflection.newInstance(values2.getClass().getComponentType(), newSize);
        if (head2 < tail) {
            System.arraycopy(values2, head2, newArray, 0, tail - head2);
        } else if (this.size > 0) {
            int rest2 = values2.length - head2;
            System.arraycopy(values2, head2, newArray, 0, rest2);
            System.arraycopy(values2, 0, newArray, rest2, tail);
        }
        this.values = newArray;
        this.head = 0;
        this.tail = this.size;
    }

    public T removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        T[] values2 = this.values;
        T result2 = values2[this.head];
        values2[this.head] = null;
        ++this.head;
        if (this.head == values2.length) {
            this.head = 0;
        }
        --this.size;
        return result2;
    }

    public T removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        T[] values2 = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values2.length - 1;
        }
        T result2 = values2[tail];
        values2[tail] = null;
        this.tail = tail;
        --this.size;
        return result2;
    }

    public int indexOf(T value2, boolean identity) {
        if (this.size == 0) {
            return -1;
        }
        T[] values2 = this.values;
        int head2 = this.head;
        int tail = this.tail;
        if (identity || value2 == null) {
            if (head2 < tail) {
                int n = tail;
                for (int i = head2; i < n; ++i) {
                    if (values2[i] != value2) continue;
                    return i;
                }
            } else {
                int i;
                int n = values2.length;
                for (i = head2; i < n; ++i) {
                    if (values2[i] != value2) continue;
                    return i - head2;
                }
                n = tail;
                for (i = 0; i < n; ++i) {
                    if (values2[i] != value2) continue;
                    return i + values2.length - head2;
                }
            }
        } else if (head2 < tail) {
            int n = tail;
            for (int i = head2; i < n; ++i) {
                if (!value2.equals(values2[i])) continue;
                return i;
            }
        } else {
            int i;
            int n = values2.length;
            for (i = head2; i < n; ++i) {
                if (!value2.equals(values2[i])) continue;
                return i - head2;
            }
            n = tail;
            for (i = 0; i < n; ++i) {
                if (!value2.equals(values2[i])) continue;
                return i + values2.length - head2;
            }
        }
        return -1;
    }

    public boolean removeValue(T value2, boolean identity) {
        int index2 = this.indexOf(value2, identity);
        if (index2 == -1) {
            return false;
        }
        this.removeIndex(index2);
        return true;
    }

    public T removeIndex(int index2) {
        T value2;
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index2);
        }
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index2 + " >= " + this.size);
        }
        T[] values2 = this.values;
        int head2 = this.head++;
        int tail = this.tail--;
        index2 += head2;
        if (head2 < tail) {
            value2 = values2[index2];
            System.arraycopy(values2, index2 + 1, values2, index2, tail - index2);
            values2[tail] = null;
        } else if (index2 >= values2.length) {
            value2 = values2[index2 -= values2.length];
            System.arraycopy(values2, index2 + 1, values2, index2, tail - index2);
            --this.tail;
        } else {
            value2 = values2[index2];
            System.arraycopy(values2, head2, values2, head2 + 1, index2 - head2);
            values2[head2] = null;
        }
        --this.size;
        return value2;
    }

    public T first() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        return this.values[this.head];
    }

    public T last() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        T[] values2 = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values2.length - 1;
        }
        return values2[tail];
    }

    public T get(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index2);
        }
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index2 + " >= " + this.size);
        }
        int i = this.head + index2;
        T[] values2 = this.values;
        if (i >= values2.length) {
            i -= values2.length;
        }
        return values2[i];
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        T[] values2 = this.values;
        int head2 = this.head;
        int tail = this.tail;
        if (head2 < tail) {
            for (int i = head2; i < tail; ++i) {
                values2[i] = null;
            }
        } else {
            int i;
            for (i = head2; i < values2.length; ++i) {
                values2[i] = null;
            }
            for (i = 0; i < tail; ++i) {
                values2[i] = null;
            }
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iterable == null) {
            this.iterable = new QueueIterable(this);
        }
        return this.iterable.iterator();
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] values2 = this.values;
        int head2 = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(values2[head2]);
        int i = (head2 + 1) % values2.length;
        while (i != tail) {
            sb.append(", ").append(values2[i]);
            i = (i + 1) % values2.length;
        }
        sb.append(']');
        return sb.toString();
    }

    public int hashCode() {
        int size2 = this.size;
        T[] values2 = this.values;
        int backingLength = values2.length;
        int index2 = this.head;
        int hash = size2 + 1;
        for (int s2 = 0; s2 < size2; ++s2) {
            T value2 = values2[index2];
            hash *= 31;
            if (value2 != null) {
                hash += value2.hashCode();
            }
            if (++index2 != backingLength) continue;
            index2 = 0;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Queue)) {
            return false;
        }
        Queue q = (Queue)o;
        int size2 = this.size;
        if (q.size != size2) {
            return false;
        }
        T[] myValues = this.values;
        int myBackingLength = myValues.length;
        T[] itsValues = q.values;
        int itsBackingLength = itsValues.length;
        int myIndex = this.head;
        int itsIndex = q.head;
        for (int s2 = 0; s2 < size2; ++s2) {
            T myValue = myValues[myIndex];
            T itsValue = itsValues[itsIndex];
            if (!(myValue != null ? myValue.equals(itsValue) : itsValue == null)) {
                return false;
            }
            ++itsIndex;
            if (++myIndex == myBackingLength) {
                myIndex = 0;
            }
            if (itsIndex != itsBackingLength) continue;
            itsIndex = 0;
        }
        return true;
    }

    public static class QueueIterable<T>
    implements Iterable<T> {
        private final Queue<T> queue;
        private final boolean allowRemove;
        private QueueIterator iterator1;
        private QueueIterator iterator2;

        public QueueIterable(Queue<T> queue) {
            this(queue, true);
        }

        public QueueIterable(Queue<T> queue, boolean allowRemove) {
            this.queue = queue;
            this.allowRemove = allowRemove;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.iterator1 == null) {
                this.iterator1 = new QueueIterator<T>(this.queue, this.allowRemove);
                this.iterator2 = new QueueIterator<T>(this.queue, this.allowRemove);
            }
            if (!this.iterator1.valid) {
                this.iterator1.index = 0;
                this.iterator1.valid = true;
                this.iterator2.valid = false;
                return this.iterator1;
            }
            this.iterator2.index = 0;
            this.iterator2.valid = true;
            this.iterator1.valid = false;
            return this.iterator2;
        }
    }

    public static class QueueIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final Queue<T> queue;
        private final boolean allowRemove;
        int index;
        boolean valid = true;

        public QueueIterator(Queue<T> queue) {
            this(queue, true);
        }

        public QueueIterator(Queue<T> queue, boolean allowRemove) {
            this.queue = queue;
            this.allowRemove = allowRemove;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.queue.size;
        }

        @Override
        public T next() {
            if (this.index >= this.queue.size) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.queue.get(this.index++);
        }

        @Override
        public void remove() {
            if (!this.allowRemove) {
                throw new GdxRuntimeException("Remove not allowed.");
            }
            --this.index;
            this.queue.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

